﻿using System;
using System.Collections.Generic;
using System.Text;

using Thomas_Erdoesi.Game_Analyzer;
using Thomas_Erdoesi.Properties;

namespace Thomas_Erdoesi.Game_Objects
{
    public class GameObject
    {
        public GameObjectLocation Location;

        public GameObjectSpeed Speed;

        public int Size;

        public GameObjectLocation PredictedLocation;

        public double TimeToCollision = double.MaxValue;

        public GameObject()
        {
            Location = new GameObjectLocation();
            Speed = new GameObjectSpeed();
            Size = 0;
        }

        public GameObject(int x, int y)
        {
            Location = new GameObjectLocation(x, y);
            Speed = new GameObjectSpeed();
            Size = 0;
        }

        public GameObject(int x, int y, int size)
        {
            Location = new GameObjectLocation(x, y);
            Speed = new GameObjectSpeed();
            Size = size;
        }

        public GameObject(int x, int y, double sx, double sy)
        {
            Location = new GameObjectLocation(x, y);
            Speed = new GameObjectSpeed(sx, sy);
            Size = 0;
        }

        public GameObject(int x, int y, double sx, double sy, int size)
        {
            Location = new GameObjectLocation(x, y);
            Speed = new GameObjectSpeed(sx, sy);
            Size = size;
        }

        public GameObjectDistance GetDistance(GameObject GameObj)
        {
            return new GameObjectDistance(Location, Size, GameObj.Location, GameObj.Size);
        }

        public GameObjectDistance GetDistance(GameObjectLocation Location, int Size)
        {
            return new GameObjectDistance(this.Location, this.Size, Location, Size);
        }

        public GameObjectDistance GetDistance(GameObjectLocation Location)
        {
            return new GameObjectDistance(this.Location, this.Size, Location, 0);
        }

        public GameObjectDistance GetPredictedDistance(GameObject GameObj)
        {
            return new GameObjectDistance(PredictedLocation, Size, GameObj.PredictedLocation, GameObj.Size);
        }

        public void PredictLocation(int Frames)
        {
            PredictedLocation = new GameObjectLocation((int)(Location.x + Speed.sx * Frames), (int)(Location.y + Speed.sy * Frames));
        }

        public double CalculateTimeToCollision(Spaceship Spaceship)
        {
            TimeToCollision = GameMath.CalculateTimeToCollision(Spaceship.Location,
                                                                Spaceship.Speed,
                                                                Spaceship.Size,
                                                                Location,
                                                                Speed,
                                                                Size);
            return TimeToCollision;
        }
    }
}
